#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import sys
import os
from butterfly_predictor import predict_butterfly

def test_butterfly_prediction(image_path):
    """测试蝴蝶预测函数"""
    print(f"测试图片: {image_path}")
    
    if not os.path.exists(image_path):
        print(f"错误: 图片文件不存在: {image_path}")
        return
    
    result = predict_butterfly(image_path)
    
    if 'error' in result:
        print(f"错误: {result['error']}")
    else:
        print("\n预测结果:")
        print(f"图片: {result['image']}")
        print(f"类别ID: {result['class_id']}")
        print(f"类别名称: {result['class_name']}")
        print(f"置信度: {result['confidence']:.4f}")
        print(f"属: {result['genus']}")
        print(f"种: {result['species']}")
        print(f"科学名: {result['scientific_name']}")
        print(f"常见名: {result['common_name']}")

if __name__ == "__main__":
    # 如果没有提供参数，使用默认测试图片
    if len(sys.argv) < 2:
        test_images = [
            "../image_data/Butterfly20/001.Atrophaneura_horishanus/001.jpg",
            "../image_data/Butterfly20/002.Atrophaneura_varuna/001.jpg",
            "../image_data/Butterfly20/003.Byasa_alcinous/001.jpg"
        ]
        
        for img_path in test_images:
            if os.path.exists(img_path):
                test_butterfly_prediction(img_path)
                print("\n" + "="*50 + "\n")
            else:
                print(f"测试图片不存在: {img_path}")
    else:
        # 使用命令行参数指定的图片
        test_butterfly_prediction(sys.argv[1])
